<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Authentication extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    $this->load->library('form_validation');
  }
  public function index()
  {

    $this->form_validation->set_rules($this->_rolesLogin());
    if ($this->form_validation->run() == false) {
      $data['title'] = 'Authentication';
      $data['setting'] = $this->db->get('kop_surat')->row_array();
      $this->load->view('themplate/Authentication/header', $data);
      $this->load->view('Authentication/login');
      $this->load->view('themplate/Authentication/footer');
    } else {
      $this->_login();
    }
  }


  private function _login()
  {
    $nisn = $this->input->post('nisn');
    $pin = $this->input->post('pin');
    $user = $this->db->get_where('register', ['nisn' => $nisn])->row_array();

    // berarti ada data
    if ($user) {

      // jika user aktif
      if ($user['isAktif'] == 1) {

        if (password_verify($pin, $user['pin'])) {

          // jika pasword ada

          $data = [
            'pin' => $user['email'],
            'roles_user' => $user['roles_user']
          ];

          $this->session->set_userdata($data);
          // if untuk role
          if ($user['roles_user'] == 4) {

            redirect('Akun');
          } else {
            redirect('user');
          }
          // batas akshir if role

        } else {
          // jika password tidak ada
          $this->session->set_flashdata('message', '
          <div class="alert alert-danger" role="alert">
          Pin/Password yang anda masukan salah
          </div>');
          redirect('Authentication');
        }
      } else {
        $this->session->set_flashdata('message', '
            <div class="alert alert-danger" role="alert">
              user tidak aktif !!! silahkan aktifasi 
            </div>');
        redirect('Authentication');
      }
    } else {
      // jika tidak

      $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">
     user tidak ditemukan !!! silahkan cek kembali NISN
     </div>');
      redirect('Authentication');
    }
  }

  // logout

  public function logout()
  {
    $this->session->unset_userdata('pin');
    $this->session->unset_userdata('roles_user');

    $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">
       Anda berhasil logout
    </div>');
    redirect('Authentication');
  }


  // blocked

  public function blocked()
  {
    $this->load->view('Auth/blocked');
  }

  // private function
  private function _rolesLogin(){
    $dataRules = array(
      array(
        'field' => 'nisn',
        'label' => 'Email',
        'rules' => 'required|trim',
        'errors' => array(
          'required' => 'NISN Harus Di isi',
        )

      ), array(
        'field' => 'pin',
        'label' => 'PIN',
        'rules' => 'required|min_length[3]',
        'errors' => array(
          'required' => 'Password tidak boleh kosong',
          'min_length' => 'Password Minimal 3 Karakter'


        )
      )

    );
    return $dataRules;
  }


}
