<?php
defined('BASEPATH') or exit('No direct script access allowed');
class User extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();

    is_logged_in();
  }


  public function index()
  {
    $data['title'] = 'My Profil';
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    $this->load->view('themplate/admin/header', $data);
    $this->load->view('themplate/admin/sidebar', $data);
    $this->load->view('themplate/admin/topbar', $data);
    $this->load->view('user/index', $data);
    $this->load->view('themplate/admin/footer', $data);
  }

  public function gantiPassword()
  {
    $dataRules = array(
      array(
        'field' => 'PasswordLama',
        'label' => 'Password Lama',
        'rules' => 'required|trim',
        'errors' => array(
          'required' => 'Password Lama Harus Di input',
        )

      ), array(
        'field' => 'PasswordBaru',
        'label' => 'Password Baru',
        'rules' => 'required|min_length[5]|matches[PasswordUlang]|trim',
        'errors' => array(
          'required' => 'Password Baru tidak boleh kosong',
          'min_length' => 'Password Baru Minimal 5 Karakter',
          'matches' => 'Password tidak sama'



        )
      ),
      array(
        'field' => 'PasswordUlang',
        'label' => 'Password Ulang',
        'rules' => 'required|matches[PasswordBaru]|trim',
        'errors' => array(
          'required' => 'Password Ulang tidak boleh kosong',
          'matches' => 'Password tidak sama'



        )
      )

    );

    $data['title'] = 'Ganti Password';
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    $this->form_validation->set_rules($dataRules);
    if ($this->form_validation->run() == false) {
      $this->load->view('themplate/admin/header', $data);
      $this->load->view('themplate/admin/sidebar', $data);
      $this->load->view('themplate/admin/topbar', $data);
      $this->load->view('user/GantiPassword', $data);
      $this->load->view('themplate/admin/footer', $data);
    } else {

      $this->_ganti();
    }
  }

  private function _ganti()
  {
    $passwordLama = $this->input->post('PasswordLama');
    $passwordBaru = $this->input->post('PasswordBaru');
    $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    // var_dump($user);
    // die;

    if (password_verify($passwordLama, $user['password'])) {

      if (password_verify($passwordBaru, $user['password'])) {
        $this->session->set_flashdata('message', '
        <div class="alert alert-danger" role="alert">
        Password Baru  yang anda masukan Sama Denga yg terdaftar
        </div>');
        redirect('User/Pass');
      } else {
        $data = [
          'password' => password_hash(($this->input->post('PasswordBaru', true)), PASSWORD_DEFAULT)
        ];
        $this->db->set($data);
        $this->db->where('email', $user['email']);
        $this->db->update('user');
        $this->session->set_flashdata('message', '
        <div class="alert alert-success" role="alert">
      Password berhasil Ubah!!
        </div>');
        redirect('User/Pass');
      }
    } else {
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
      Password Lama yang anda masukan Salah
      </div>');
      redirect('User/Pass');
    }
  }

  public function EditEmail()
  {
    $dataRules = array(
      array(
        'field' => 'EmailLama',
        'label' => 'Email Lama',
        'rules' => 'required|trim|valid_email',
        'errors' => array(
          'required' => 'Email Lama Harus Di input',
          'valid_email' => 'Email Tidak valid'

        )

      ),
      array(
        'field' => 'EmailBaru',
        'label' => 'Email Baru',
        'rules' => 'required|trim|valid_email',
        'errors' => array(
          'required' => 'Email Baru Harus Di input',
          'valid_email' => 'Email Tidak valid'
        )

      ),
      array(
        'field' => 'EmailUlang',
        'label' => 'Email Ulang',
        'rules' => 'required|trim|valid_email',
        'errors' => array(
          'required' => 'Email Ulang Harus Di input',
          'valid_email' => 'Email Tidak valid'

        )

      )
    );

    $data['title'] = 'Ganti Email';
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    $this->form_validation->set_rules($dataRules);
    if ($this->form_validation->run() == false) {
      $this->load->view('themplate/admin/header', $data);
      $this->load->view('themplate/admin/sidebar', $data);
      $this->load->view('themplate/admin/topbar', $data);
      $this->load->view('user/GantiEmail', $data);
      $this->load->view('themplate/admin/footer', $data);
    } else {

      $this->_gantiEmail();
    }
  }


  private function _gantiEmail()
  {

    $EmailBaru = $this->input->post('EmailBaru');
    $EmailLama = $this->input->post('EmailLama');
    $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    if ($EmailLama == $user['email']) {

      if ($user['email'] == $EmailBaru) {
        $this->session->set_flashdata('message', '
        <div class="alert alert-danger" role="alert">
        Email Baru  yang anda masukan Sama Denga yg terdaftar
        </div>');
        redirect('User/EditEmail');
      } else {
        $data = [
          'email' => $this->input->post('EmailBaru')
        ];
        $this->db->set($data);
        $this->db->where('email', $user['email']);
        $this->db->update('user');
        $this->_logout();
      }
    } else {
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
      Email Lama yang anda masukan Salah
      </div>');
      redirect('User/EditEmail');
    }
  }

  private function _logout()
  {

    $this->session->unset_userdata('email');
    $this->session->unset_userdata('role_id');

    $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">
  Ubah Email Berhasi Silahkan Login
    </div>');
    redirect('auth');
  }
}
