function baseUrl() {
  var url = $(".url").data("url");
  return url;
}

$(".tombolEditInformasi").on("click", function () {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $("#formUser").attr("action", baseUrl() + "ppdb/editInformasi");
  $("#titleInformasi").val("");
  $("#idInformasi").val("");
  let id = $(this).data("id");
  $.ajax({
    url: baseUrl() + "Ppdb/getDataInformasi",
    data: {
      id: id,
    },
    method: "post",
    dataType: "json",
    success: function (respon) {
      $("#titleInformasi").val(respon.title);
      $("#idInformasi").val(respon.id);

      CKEDITOR.instances["deskripsi"].setData(respon.deskripsi);
      $("#buttonEditSimpanInformasi").html("Edit Informasi");
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
});

// input identitas kepala sekolah
// nama
$("#namaKepala").focusout(function () {
  let value = $(this).val();
  let kolom = $(this).data("kolom");
  editKepalaSekolah(kolom, value);
});

// input nip kepala sekolah
$("#nipKepala").focusout(function () {
  let value = $(this).val();
  let kolom = $(this).data("kolom");
  editKepalaSekolah(kolom, value);
});

// input nomor surat
$("#nomorSurat").focusout(function () {
  let value = $(this).val();
  let kolom = $(this).data("kolom");
  editKepalaSekolah(kolom, value);
});

// input tanggal surat
$("#tanggalSurat").focusout(function () {
  let value = $(this).val();
  let kolom = $(this).data("kolom");
  editKepalaSekolah(kolom, value);
});


// edit nip dan nama kepala sekolah
function editKepalaSekolah(kolom, data, id = 1) {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: baseUrl() + "Setting/ubahDataKepsek",
    data: {
      kolom: kolom,
      value: data,
      id: id,
    },
    method: "post",
    dataType: "json",
    success: function (respon) {
      if (respon.pesan == "success") {
        Swal.fire({
          icon: "success",
          title: "Berhasil !!!",
          text: "Data telah di rubah",
          timer: 2000,
        });
      } else {
        Swal.fire({
          icon: "warning",
          title: "Warning !",
          text: "Tida ada data yang dirubah",
          timer: 2000,
        });
      }
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// console.log(startTime);
$(".tanggalLahir").datepicker({
  defaultDate: "01-06-2006",
  altField: "#actualDate",
  dateFormat: "dd-mm-yy",
  dayNames: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
  dayNamesMin: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
  duration: "slow",
  minDate: new Date(2006, 1 - 1, 1),
  changeYear: true,
  yearRange: "2006:2011",
  changeMonth: true,
});
$(".ui-datepicker").addClass("notranslate");
$("#tanggakKelulusan").datepicker({
  altField: "#actualDate",
  dateFormat: "dd-mm-yy",
  dayNames: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
  dayNamesMin: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
  duration: "slow",
  changeYear: true,
  changeMonth: true,
});

$(".edit").on("click", function () {
  $(".input-hidden").fadeOut();
  var id = $(this).data("id");
  var base_url = $("#url").val() + "setting/getDataUser";
  var base_url2 = $("#url").val() + "setting/editUser";
  $("#formUser").attr("action", base_url2);
  $.ajax({
    url: base_url,
    data: {
      id: id,
    },
    method: "post",
    dataType: "json",
    success: function (respon) {
      // console.log(respon.id)
      $("#idUser").val(respon.id);
      $("#namaUser").val(respon.name);
      $("#emailUser").val(respon.email);
      $("#emailUser").attr("readonly", "readonly");
      $("#userAkses").val(respon.role_id);
      // $('#status').val(respon.role_id);
    },
  });
});

// hapus data Operator
$(".hapusDataOperator").on("click", function (e) {
  e.preventDefault();
  const hrefHapus = $(this).attr("href");
  let nama = $(this).data("nm");
  Swal.fire({
    title: "Anda Yakin?",
    text: `Ingin Menghapus Data Operator : ${nama}`,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Hapus Saja",
  }).then((result) => {
    if (result.value) {
      document.location.href = hrefHapus;
    }
  });
});

$(".btnResetPerbaikan").on("click", function (e) {
  e.preventDefault();
  const hrefHapus = $(this).attr("href");
  let nama = $(this).data("nama");
  Swal.fire({
    title: "Anda Yakin?",
    text: `Ingin Reset Data  ${nama} Ke Perbaikan?:`,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Hapus Saja",
  }).then((result) => {
    if (result.value) {
      document.location.href = hrefHapus;
    }
  });
});

// untuk reset pin operartor
$(".button-reset-Operator").on("click", function () {
  let id = $(this).data("id");
  Swal.fire({
    title: "Anda Yakin?",
    text: "Ingin reset password Operator",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Reset Password",
  }).then((result) => {
    if (result.value) {
      $(".loading").css("top", "0");
      $(".gambar-loading").css("opacity", "1");
      resetPinOperator(id);
    }
  });
});

function resetPinOperator(id) {
  let url = baseUrl();
  $.ajax({
    url: url + "Setting/resetPINOperator",
    method: "post",
    dataType: "json",
    data: {
      id: id,
    },
    success: function (respon) {
      if (respon.pesan == "noUser") {
        Swal.fire({
          icon: "error",
          title: "Error",
          text: "Gagal Reset User Tidak Ditemikan",
          timer: 2000,
        });
      } else {
        Swal.fire({
          icon: "success",
          title: "Success",
          text: `Password Operator ${respon.name}  berhasil di Reset Dengan Password Baru : ${respon.newPIN}`,
        });
      }
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// edit adata operator
$(".editOperator").on("click", function () {
  $(".input-hidden").fadeOut();
  $("#operatorModel").modal("show");
  var id = $(this).data("id");
  var base_url = $("#url").val() + "setting/getDataUser";
  var base_url2 = $("#url").val() + "setting/editOperator";
  $("#formOperator").attr("action", base_url2);
  $.ajax({
    url: base_url,
    data: {
      id: id,
    },
    method: "post",
    dataType: "json",
    success: function (respon) {
      $("#idOperator").val(respon.id);
      $("#namaOperator").val(respon.name);
      $(".emailOperator").val(respon.email);
      $(".emailOperator").attr("readonly", "readonly");
      $("#namaSekolahOpsOperator").val(respon.asal_sekolah_ops);
      $("#npsnOps").val(respon.npsnOps);
    },
  });
});

$("#tambahUser").on("click", function () {
  // $('#emailUser').val(respon.email).removeAttr('readonly');
  $("#emailUser").removeAttr("readonly", "readonly");
  var base_url = $("#url").val() + "setting/tambahUser";
  $(".input-hidden").fadeIn();
  $("#formUser")[0].reset();
  $("#formUser").attr("action", base_url);
});

$("#tombolTambahOperator").on("click", function () {
  console.info("ok click operator");
  $("#operatorModel").modal("show");
  // $('#emailUser').val(respon.email).removeAttr('readonly');
  $(".emailOperator").removeAttr("readonly", "readonly");
  var base_url = $("#url").val() + "setting/tambahUserOperator";
  $(".input-hidden").fadeIn();
  $("#formOperator")[0].reset();
  $("#formOperator").attr("action", base_url);
});

// edit data persyaratan
$(".tombolEdit").on("click", function () {
  $(".modal-title").html("Edit Persyaratan");
  var id = $(this).data("id");
  var base_url = $("#url").val() + "ppdb/edit";
  var base_url2 = $("#url").val() + "ppdb/editProses";
  $("#formUser").attr("action", base_url2);
  $.ajax({
    url: base_url,
    data: {
      id: id,
    },
    method: "post",
    dataType: "json",
    success: function (respon) {
      $("#syaratPpdb").val(respon.persyaratan);
      $("#jalurPpdb").val(respon.id_jalur);
      $("#idSyarat").val(respon.id);
    },
  });
});

// data afirmasi
$('body #formTabelAfirmasi').validate({

  rules: {
    namaAfirmasi: {
      required:true
    }
  },
  messages: {
    namaAfrimasi: {
      required:'Nama jenis afirmasi'
    }
  }
  

});

// tombol edit data afirmasi atable
$(".tombolEditAfirmasi").on("click", function () {
  $(".modal-title").html("Edit Nama Jenis Afirmasi");
  $('.modal-footer .tombol-edit-tambah-afirmasi').html('Edit Data')
  var id = $(this).data("id");
  $(".namaAfirmasiUntukTable").val('');
  $(".idAfirmasi").val('');
  var base_url = $("#url").val() + "ppdb/getDataAfirmasiUntukTableAfirmasi";
  var base_url2 = $("#url").val() + "ppdb/editProsesDataAfirmasi";
  $("#formTabelAfirmasi").attr("action", base_url2);
   $("#formTabelAfirmasi")[0].reset();
  $.ajax({
    url: base_url,
    data: {
      id: id,
    },
    method: "post",
    dataType: "json",
    success: function (respon) {
      console.info(respon)
      $(".namaAfirmasiUntukTable").val(respon?.nama_jenis_afirmasi);
      $(".idAfirmasi").val(respon?.id);
    },
  });
});

$(".tombolTambahAfirmasi").on("click", function () {
  $('.modal-footer .tombol-edit-tambah-afirmasi').html('Tambah Data')
  var base_url = $("#url").val() + "ppdb/tambahAfirmasi";
  $("#formTabelAfirmasi")[0].reset();
  $("#formTabelAfirmasi").attr("action", base_url);
  $("#namaAfirmasiUntukTable").val('');
  $("#idAfirmasi").val('');
});

$(".container-fluid").on("click", ".tombolHapusAfirmasi", function (e) {
  e.preventDefault();
  const hrefHapus = $(this).attr("href");
  Swal.fire({
    title: "Anda Yakin?",
    text: "Ingin Menghapus Data Skor",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Hapus Saja",
  }).then((result) => {
    if (result.value) {
      document.location.href = hrefHapus;
    }
  });
});


// edit data skore rangking
$(".tombolEditRangking").on("click", function () {
  $(".modal-title").html("Edit Skor Rangking");
  var id = $(this).data("id");
  var base_url = $("#url").val() + "ppdb/getDataRangking";
  var base_url2 = $("#url").val() + "ppdb/editProsesRangking";
  $("#formRangking").attr("action", base_url2);
   $("#formRangking")[0].reset();
  $.ajax({
    url: base_url,
    data: {
      id: id,
    },
    method: "post",
    dataType: "json",
    success: function (respon) {
      $("#namaRangking").val(respon?.rangking);
      $(".skorRangking").val(respon?.skorRanking);
      $("#idRangking").val(respon?.id_rangking);
    },
  });
});

// hapus data skor rangking


// tombol untuk tambah data skore rangking
$(".tombolTambahRangking").on("click", function () {
  var base_url = $("#url").val() + "ppdb/rangking";
  $("#formRangking")[0].reset();
  $("#formRangking").attr("action", base_url);
});

$(".tombolTambah").on("click", function () {
  $(".modal-title").html("Tambah Persyaratan");
  var base_url = $("#url").val() + "ppdb";
  $("#formUser")[0].reset();
  $("#formUser").attr("action", base_url);
});

// edit data jalur ppdb

$(".tombolEditJalur").on("click", function () {
  $(".modal-title").html("Edit Jalur PPDB");
  var id = $(this).data("id");
  var base_url = $("#url").val() + "ppdb/getJalurByid";
  var base_url2 = $("#url").val() + "ppdb/editJalurPpdb";
  $(".modal-footer button[type=submit]").html("edit");
  $("#formUser").attr("action", base_url2);
  $.ajax({
    url: base_url,
    data: {
      id: id,
    },
    method: "post",
    dataType: "json",
    success: function (respon) {
      console.info(respon);
      $("#jalurPpdb").val(respon?.ppdb);
      $("#quota").val(respon?.quota);
      $("#input_nilai").val(respon?.input_nilai);
      $("#input_afirmasi").val(respon?.input_afirmasi);
      $("#inputPrestasi").val(respon?.inputPrestasi);
      $("#statusAktif").val(respon?.statusAktif);
      $("#idJalur").val(respon?.id);
    },
  });
});

$(".tombolTambahJalur").on("click", function () {
  $(".modal-title").html("Tambah Jalur PPDB");
  $(".modal-footer button[type=submit]").html("simpan");
  var base_url = $("#url").val() + "ppdb/jalurPPDB";
  $("#formUser")[0].reset();
  $("#formUser").attr("action", base_url);
});

// edit Nilai Prestasi nonakademik
$(".tombolEditPrestasi").on("click", function () {
  $(".modal-title").html("Edit Score Nilai Nonakademik");
  var id = $(this).data("id");
  var base_url = baseUrl() + "ppdb/getDataPrestasi";
  var base_url2 = baseUrl() + "ppdb/editNilaiPrestasi";
  var base_url3 = baseUrl() + "ppdb/getDataKatSatuan";
  $(".modal-footer button[type=submit]").html("edit");
  console.info(baseUrl())
  $("#formUser").attr("action", base_url2);
  $.ajax({
    url: base_url,
    data: {
      id: id,
    },
    method: "post",
    dataType: "json",
    success: function (respon) {
      console.info(respon)
      $("#kategori").html("");
      // get data satuan
      $.ajax({
        url: base_url3,
        data: {
          id: respon.id_satuan,
        },
        method: "post",
        dataType: "json",
        success: function (respon2) {
          $("#penyelengaraChange").val(respon2.id_penyelengara);
          $("#kategoriChange").append(
            `<option value="` +
              respon2.id_satuan +
              `">` +
              respon2.satuan +
              `</option>`
          );
        },
      });
      $("#tingkatChange").val(respon.kejuaraan);
      $("#nilaiPrestasi").val(respon.score);
      $("#idPrestasi").val(respon.id);
    },
  });
});

$(".tombolTambahPrestasi").on("click", function () {
  $("#kategori").html("");
  $(".modal-title").html("Tambah Nilai Nonakademik");
  $(".modal-footer button[type=submit]").html("simpan");
  var base_url = $("#url").val() + "ppdb/nonAkademik";
  $("#formUser")[0].reset();
  $("#formUser").attr("action", base_url);
});
// batas akhir edit prestasi
// edit informasi
// CKEDITOR.replace('deskripsi');
$(".tombolTambahInformasi").on("click", function () {
  CKEDITOR.instances["deskripsi"].setData("");
  $(".modal-title").html("Tambah Informasi");
  // cekeditor
  $(".modal-footer button[type=submit]").html("simpan");
  var base_url = $("#url").val() + "ppdb/informasi";
  $("#formUser")[0].reset();
  $("#formUser").attr("action", base_url);
});
// console.log(CKEDITOR)
// aktif nonaktif form
$("#formAktif").on("click", function () {
  var nilai = $(this).val();
  var url = $("#url").val();
  let kolom = $(this).data("kolom");
  $.ajax({
    url: url + "Setting/aktifForm",
    method: "post",
    data: {
      id: 1,
      kolom: kolom,
    },
    success: function (respon) {
      Swal.fire({
        icon: "success",
        title: "Success",
        text: "OK",
        timer: 2000,
      });
    },
  });
});

// aktif non aktif statistik di depan
$("#onStstistik").on("click", function () {
  var nilai = $(this).val();
  var url = $("#url").val();
  let kolom = $(this).data("kolom");
  alert(kolom);
  $.ajax({
    url: url + "Setting/aktifForm",
    method: "post",
    data: {
      id: 1,
      kolom: kolom,
    },
    success: function (respon) {
      Swal.fire({
        icon: "success",
        title: "Success",
        text: "OK",
        timer: 2000,
      });
    },
  });
});

// aktif non aktif login operator
$("#onOperator").on("click", function () {
  var nilai = $(this).val();
  var url = $("#url").val();
  let kolom = $(this).data("kolom");
  $.ajax({
    url: url + "Setting/aktifForm",
    method: "post",
    data: {
      id: 1,
      kolom: kolom,
    },
    success: function (respon) {
      Swal.fire({
        icon: "success",
        title: "Success",
        text: "OK",
        timer: 2000,
      });
    },
  });
});
// new tombol verifikasi========2023===================
$('.card-body').on('click', ".btnGetDataVerifikasi", function () {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $('#smartwizard').smartWizard("reset");
  let id = $(this).data('id');
  let koreg = $(this).data('koreg');
  $.ajax({
    url: baseUrl() + "Admin/getDataVerifikasi",
    method: "POST",
    data: {
      id: id,
      koreg:koreg
    },
    dataType: "json",
    success: function (response) {
      $(".loading").css("top", "0");
      $(".gambar-loading").css("opacity", "1");
      let dataJalur = response?.dataJalur
      let dataUser = response?.user
      // console.info(dataUser)
      let dataPrestasi = response?.dataKejuaraan
      let dataAfirmasi = response?.dataAfirmasi;

    
      
      $('.formAlamat #koreg').val(dataUser?.koreg);
      $('.formAlamat #id_pendaftar').val(dataUser?.id_pendaftar);
      $('.formAlamat .changeProvinsi').val(dataUser?.id_provinsi);
      $('.formAlamat .changeKota').html(`
      <option value="${dataUser?.id_kota}" selected>${dataUser?.kota}</option>
      `)
      $('.formAlamat .changeKecamatan').html(`
      <option value="${dataUser?.id_kecamatan}" selected>${dataUser?.kecamatan}</option>
      `)
      $('.formAlamat .changeDesa').html(`
      <option value="${dataUser?.id_desa}" selected>${dataUser?.desa}</option>
      `)
      
      $('.formAlamat #rt').val(`${dataUser?.rt}`)
      $('.noHp').val(`${dataUser?.noHp}`)
      $('.formAlamat #rw').val(`${dataUser?.rw}`)
      $('.formAlamat #alamat').val(dataUser?.alamat)
      $('.formAlamat #kodePos').val(dataUser?.kodePos)

      $('#jalurPpdb').val(dataUser?.id_jalur)

      $('id_pendaftar').val(dataUser?.id_pendaftar);
      // cek dulu apa yang yang di syarataka jalur yang di pilih
      if (dataJalur?.input_nilai == 1) {
        $(".content-syarat-khusus .raport").css("display", "block");
         clearFormRaport()
         dataNilaiRaport(dataUser.id_pendaftar)
      } else {
        $(".content-syarat-khusus .raport").css("display", "none");
      }

     
      if (dataJalur?.input_afirmasi == 1) {
        $(".content-syarat-khusus .afirmasi").css("display", "block");
        $(".content-syarat-khusus .namaAfirmasi").html("");
        $('.jenis_afirmasi').val("")
        $('.no_afirmasi').val("")
        $('.nama_afirmasi').val("")
        $('.dtks').val("")
     
        $('.jenis_afirmasi').val(dataAfirmasi?.afirmasi)
        $('.no_afirmasi').val(dataAfirmasi?.no_afirmasi)
        $('.nama_afirmasi').val(dataAfirmasi?.nama_afirmasi)
        $('.dtks').val(dataAfirmasi?.dtks)
      } else {
      
        
     $(".content-syarat-khusus .afirmasi").css("display", "none");
     
      }

      if (dataJalur?.inputPrestasi == 1) {
          // hapus dulu data kejuaraan nya
      $('.container-berkas .penyelengara').val("")
      $('.kejuaraan .kategori').html(``)
      $('.prestasi').html('')
      $('.kejuaraan .skor').val("")
      $('.kejuaraan .namaKejuaraan').val("")
      $('.kejuaraan .skorKompentensi').val("")
      $('.kejuaraan .total_skor_kejuaraan').val("")
      // end hapus data kejuaraan
      $(".content-syarat-khusus .kejuaraan").css("display", "block");
  

        $('.container-berkas .penyelengara').val(dataPrestasi?.id_penyelengara)
        $('.kejuaraan .kategori').append(`
          <option value="${dataPrestasi?.id_satuan}">${dataPrestasi?.satuan}</option>
        `)
        $('.prestasi').append(`
          <option value="${dataPrestasi?.id_kejuaraan}">${dataPrestasi?.kejuaraan}</option>
        `)
        $('.kejuaraan .skor').val(dataPrestasi?.skor)
        $('.kejuaraan .namaKejuaraan').val(dataPrestasi?.namaKejuaraan)
        $('.kejuaraan .skorKompentensi').val(dataPrestasi?.skorKompetensi)
        $('.kejuaraan .total_skor_kejuaraan').val(dataPrestasi?.total_skor_kejuaraan)

       // $(".afirmasi .afirmasi-main .namaAfirmasi").html('')
      
        
      } else {
     $(".content-syarat-khusus .kejuaraan").css("display", "none");
     
      }
      // ambil data sesuai apa yang di butuhkan oleh jalur tersebut

      // load data yanga ada pada user
      $('.modalPendaftar .id_pendaftar').val(dataUser.id_pendaftar);
      $('.modalPendaftar .noDaftar').val(dataUser.noDaftar);
      $('.modalPendaftar .jarak').val(dataUser.jarak.jarak);
      $('.modalPendaftar .statusDaftar').val(dataUser.statusDaftar)
      $('.modalPendaftar .koreg').val(dataUser.koreg);
      $('.modalPendaftar .nik').val(dataUser.nik);

      $('.modalPendaftar .email').val(dataUser.email)
      $('.modalPendaftar .nama').val(dataUser.nama)
      $('.modalPendaftar .tempatLahir').val(dataUser.tempatLahir)
      $('.modalPendaftar .tglLahir').val(dataUser.tglLahir)
      $('.modalPendaftar .agama').val(dataUser.agama)
      $('.modalPendaftar .tglDaftar').val(dataUser.tglDaftar)
      $('.modalPendaftar .jk').val(dataUser.jk)
      $('.modalPendaftar .sekolahAsal').val(dataUser.sekolahAsal)
      // new tombol verifikasi==========================
      $('.modalPendaftar .kk').val(dataUser?.kk);
      $('.modalPendaftar .nisn').val(dataUser?.nisn);
      $('.modalPendaftar .rt').val(dataUser?.rt)
      $('.modalPendaftar .jarak').val(dataUser?.jarak)
      $('.modalPendaftar .rw').val(dataUser?.rw)
      $('.modalPendaftar .desa').val(dataUser?.id_desa)
      // $('.modalPendaftar .kecamatan').val(datauser?.id_kecamatan)
      // $('.modalPendaftar .provinsi').val(dataUser?.id_provinsi)
      // $('.modalPendaftar .kodePost').val(datauser?.kodePos)
      $('.modalPendaftar .longitude').val(dataUser?.longitude)
    },
    complete: function (xhr, status) {
      $('.modalPendaftar').modal('show');
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
    error: function (xhr, status, error) {
      Swal.fire({
        icon: "error",
        title: error,
        text: status,
      });
    },
   
  });
 
 
})


$(".ui-datepicker").addClass("notranslate");
$("#tglLahir").datepicker({
  defaultDate: "01-06-2012",
  altField: "#actualDate",
  defaultDate: "01-06-2012",
  dateFormat: "dd-mm-yy",
  dayNames: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
  dayNamesMin: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
  duration: "slow",
  minDate: new Date('2008', '01', '01'),
  changeYear: true,
  yearRange: "2008:2015",
  changeMonth: true,
});



// function tampilkanFormAfirmasi(id) {
//   $.ajax({
//     url: baseUrl() + "Admin/getDataAfirmasi",
//     method: "POST",
//     data: {
//       id: id,
//       koreg:koreg
//     }, biforeSend: function () {
//       $(".loading").css("top", "0");
//       $(".gambar-loading").css("opacity", "1");
//     },
//     dataType: "json",
//     success: function (response) {
//     //
      
     

            

            
//     },
//     complete: function (xhr, status) {
//       $('.modalPendaftar').modal('show');
//       $(".loading").css("top", "100%");
//       $(".gambar-loading").css("opacity", "0");
//     },
//     error: function (xhr, status, error) {
//       Swal.fire({
//         icon: "error",
//         title: error,
//         text: status,
//       });
//     },
   
//   });
// }


// kejuaraan
// $('.namaKejuaraan').val()
// $('.skorKompetensi').val()
// $('.total_skor_kejuaraan').val()

// // raport()
// $('.total').val()
// $('.skorRank').val()
// $('.rank').val()
// $('.totalSkor').val()
// load data raport
// hapus dulu data raport
function clearFormRaport() {
	$('.raport .raport-item1').html("");
	$('.totalNilai').val(``);
	$('.totalSkor').val();
	$('.skoreRank').val();
	$('.rangking').append(
		`
		<option value="0">Pilih Rangking</option>
	  `
  );
  $('#paiK4S1').val("")
  $('#paiK4S2').val("")
  $('#paiK5S1').val("")
  $('#paiK5S2').val("")
  $('#paiK6S1').val("")
  
  $('#pknK4S1').val("")
  $('#pknK4S2').val("")
  $('#pknK5S1').val("")
  $('#pknK5S2').val("")
  $('#pknK6S1').val("")
  
  $('#indoK4S1').val("")
  $('#indoK4S2').val("")
  $('#indoK5S1').val("")
  $('#indoK5S2').val("")
  $('#indoK6S1').val("")
  
  $('#mtkK4S1').val("")
  $('#mtkK4S2').val("")
  $('#mtkK5S1').val("")
  $('#mtkK5S2').val("")
  $('#mtkK6S1').val("")
  
  $('#ipaK4S1').val("")
  $('#ipaK4S2').val("")
  $('#ipaK5S1').val("")
  $('#ipaK5S2').val("")
  $('#ipaK6S1').val("")
  
  $('#ipsK4S1').val("")
  $('#ipsK4S2').val("")
  $('#ipsK5S1').val("")
  $('#ipsK5S2').val("")
  $('#ipsK6S1').val("")
  
  $('#sbdpK4S1').val("")
  $('#sbdpK4S2').val("")
  $('#sbdpK5S1').val("")
  $('#sbdpK5S2').val("")
  $('#sbdpK6S1').val("")
  
  $('#pjokK4S1').val("")
  $('#pjokK4S2').val("")
  $('#pjokK5S1').val("")
  $('#pjokK5S2').val("")
  $('#pjokK6S1').val("")
  
  $('#sundaK4S1').val("")
  $('#sundaK4S2').val("")
  $('#sundaK5S1').val("")
  $('#sundaK5S2').val("")
  $('#sundaK6S1').val("")
	
  }
function dataNilaiRaport(id) {
  $('.raport .raport-item1').html('');
  $.ajax({
    url: baseUrl() + "Admin/loadDataRaportByPendaftar",
    method: "post",
    data: {
      id: id,
    },
    dataType: "json",
    success: function (response) {
      $('.raport .raport-item1').append(`
        <div class="row my-3">
            <div class="col-4 col-lg-4">
              <label for="totalNilai">Total Rata Rata</label>
              <input type="text" value="${response?.total}" class="totalNilai form-control form-control-sm form-control-custum" readonly name="totalNilai" id="totalNilai"  placeholder="Tempat lahir">
            </div>
          <div class="col-4 col-lg-4">
            <label for="skorRank">Skor Rangking</label>
            <input type="text" value="${response?.skorRank}" class="skorRank form-control form-control-sm form-control-custum" readonly id="skorRank" name="skorRank" placeholder="Rangking">
          </div>
          <div class="col-4 col-lg-4">
            <label for="totalSkor">Total Nilai</label>
            <input type="text" value="${response?.totalSkor}" class="totalSkor form-control form-control-sm form-control-custum" readonly id="totalSkor" name="totalSkor" placeholder="Rangking">
          </div>
        </div>
      
      `);
      $('.rangking').val(response?.isRank);
      $('#paiK4S1').val(response?.paiK4S1)
      $('#paiK4S2').val(response?.paiK4S2)
      $('#paiK5S1').val(response?.paiK5S1)
      $('#paiK5S2').val(response?.paiK5S2)
      $('#paiK6S1').val(response?.paiK6S1)
      
      $('#pknK4S1').val(response?.pknK4S1)
      $('#pknK4S2').val(response?.pknK4S2)
      $('#pknK5S1').val(response?.pknK5S1)
      $('#pknK5S2').val(response?.pknK5S2)
      $('#pknK6S1').val(response?.pknK6S1)
      
      $('#indoK4S1').val(response?.indoK4S1)
      $('#indoK4S2').val(response?.indoK4S2)
      $('#indoK5S1').val(response?.indoK5S1)
      $('#indoK5S2').val(response?.indoK5S2)
      $('#indoK6S1').val(response?.indoK6S1)

      $('#mtkK4S1').val(response?.mtkK4S1)
      $('#mtkK4S2').val(response?.mtkK4S2)
      $('#mtkK5S1').val(response?.mtkK5S1)
      $('#mtkK5S2').val(response?.mtkK5S2)
      $('#mtkK6S1').val(response?.mtkK6S1)

      $('#ipaK4S1').val(response?.ipaK4S1)
      $('#ipaK4S2').val(response?.ipaK4S2)
      $('#ipaK5S1').val(response?.ipaK5S1)
      $('#ipaK5S2').val(response?.ipaK5S2)
      $('#ipaK6S1').val(response?.ipaK6S1)
      
      $('#ipsK4S1').val(response?.ipsK4S1)
      $('#ipsK4S2').val(response?.ipsK4S2)
      $('#ipsK5S1').val(response?.ipsK5S1)
      $('#ipsK5S2').val(response?.ipsK5S2)
      $('#ipsK6S1').val(response?.ipsK6S1)

      $('#sbdpK4S1').val(response?.sbdpK4S1)
      $('#sbdpK4S2').val(response?.sbdpK4S2)
      $('#sbdpK5S1').val(response?.sbdpK5S1)
      $('#sbdpK5S2').val(response?.sbdpK5S2)
      $('#sbdpK6S1').val(response?.sbdpK6S1)

      $('#pjokK4S1').val(response?.pjokK4S1)
      $('#pjokK4S2').val(response?.pjokK4S2)
      $('#pjokK5S1').val(response?.pjokK5S1)
      $('#pjokK5S2').val(response?.pjokK5S2)
      $('#pjokK6S1').val(response?.pjokK6S1)

      $('#sundaK4S1').val(response?.sundaK4S1)
      $('#sundaK4S2').val(response?.sundaK4S2)
      $('#sundaK5S1').val(response?.sundaK5S1)
      $('#sundaK5S2').val(response?.sundaK5S2)
      $('#sundaK6S1').val(response?.sundaK6S1)
    },
    complete: function (xhr, status) {
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
    error: function (xhr, status, error) {
      Swal.fire({
      icon: "error",
      title: 'Error',
      text: "Data gagal di muat status kode:"+error,
      });
    },
    });
  }












// batas akhir edit informasi versi yang lama
$(".card-body").on("click", ".viewPendaftar", function () {
  var koreg = $(this).data("koreg");
  var id = $(this).data("id");
  var url = $(".url").val();
  alert(url)
  $.ajax({
    url: url + "Admin/getDataVerifikasi",
    method: "POST",
    data: {
      id: id,
      koreg: koreg,
    },
    dataType: "json",
    success: function (respon) {
      if (respon.statusDaftar == 2) {
        $("#ver1").attr("checked", "checked");
      } else if (respon.statusDaftar == 3) {
        $("#ver2").attr("checked", "checked");
      } else {
        $("#ver3").attr("checked", "checked");
      }
      // form value
      $("#koreg").val(respon.koreg);
      $("#nama").val(respon.nama);
      $("#nisn").val(respon.nisnPendaftar);
      $("#namaSekolah").val(respon.sekolahAsal);
      $("#nilaiPrestasiPraktek").val(respon.nilaiPraktekPrestasi);
      $("#cabangPrestasi").val(respon.cabangPrestasi);
      $("#npsn").val(respon.npsn);
      $("#JalurPPDB").val(respon.id_jalur);
      $("#tingkat2").val(respon.idPrestasi);
      $("#nilaiJarak").val(respon.jarak);
      $("#nilaiPrestasi").val(respon.nilaiPrestasi);
      $("#totalNilai").val(respon.total);
      $("#longitude").val(respon.longitude);
      $("#idDaftar").val(respon.id_pendaftar);
      $("#koregSen").val(respon.koreg);
      $(".inputNilaiPraktek").val(respon.nilaiPraktekPrestasi);
      $("#totalRataRata").val(respon.jumlahRataRata);
      $("#tempatLahir").val(respon.tempatLahir);
      $("#tanggalLahir").val(respon.tglLahir);
      $("#usiaSiswa").val(respon.usia + " Tahun");

      // buat apdate nilai prkatek
      $("#idEdit").val(respon.id);
      $("#koregEdit").val(respon.koreg);
      // nilai pai
      $("#paiK4S1").val(respon.paiK4S1);
      $("#paiK4S2").val(respon.paiK4S2);
      $("#paiK5S1").val(respon.paiK5S1);
      $("#paiK5S2").val(respon.paiK5S2);
      $("#paiK6S1").val(respon.paiK6S1);
      $("#paiK6S2").val(respon.paiK6S2);
      // batas Nilai pai

      // nilai pkn
      $("#pknK4S1").val(respon.pknK4S1);
      $("#pknK4S2").val(respon.pknK4S2);
      $("#pknK5S1").val(respon.pknK5S1);
      $("#pknK5S2").val(respon.pknK5S2);
      $("#pknK6S1").val(respon.pknK6S1);
      $("#pknK6S2").val(respon.pknK6S2);
      // batas Nilai pkn

      // nilai indo
      $("#indoK4S1").val(respon.indoK4S1);
      $("#indoK4S2").val(respon.indoK4S2);
      $("#indoK5S1").val(respon.indoK5S1);
      $("#indoK5S2").val(respon.indoK5S2);
      $("#indoK6S1").val(respon.indoK6S1);
      $("#indoK6S2").val(respon.indoK6S2);
      // batas Nilai indo

      // nilai mtk
      $("#mtkK4S1").val(respon.mtkK4S1);
      $("#mtkK4S2").val(respon.mtkK4S2);
      $("#mtkK5S1").val(respon.mtkK5S1);
      $("#mtkK5S2").val(respon.mtkK5S2);
      $("#mtkK6S1").val(respon.mtkK6S1);
      $("#mtkK6S2").val(respon.mtkK6S2);
      // batas Nilai mtk

      // nilai ipa
      $("#ipaK4S1").val(respon.ipaK4S1);
      $("#ipaK4S2").val(respon.ipaK4S2);
      $("#ipaK5S1").val(respon.ipaK5S1);
      $("#ipaK5S2").val(respon.ipaK5S2);
      $("#ipaK6S1").val(respon.ipaK6S1);
      $("#ipaK6S2").val(respon.ipaK6S2);
      // batas Nilai ipa

      // nilai ips
      $("#ipsK4S1").val(respon.ipsK4S1);
      $("#ipsK4S2").val(respon.ipsK4S2);
      $("#ipsK5S1").val(respon.ipsK5S1);
      $("#ipsK5S2").val(respon.ipsK5S2);
      $("#ipsK6S1").val(respon.ipsK6S1);
      $("#ipsK6S2").val(respon.ipsK6S2);
      // batas Nilai ips

      // nilai sbdp
      $("#sbdpK4S1").val(respon.sbdpK4S1);
      $("#sbdpK4S2").val(respon.sbdpK4S2);
      $("#sbdpK5S1").val(respon.sbdpK5S1);
      $("#sbdpK5S2").val(respon.sbdpK5S2);
      $("#sbdpK6S1").val(respon.sbdpK6S1);
      $("#sbdpK6S2").val(respon.sbdpK6S2);
      // batas Nilai sbdp

      // nilai pjok
      $("#pjokK4S1").val(respon.pjokK4S1);
      $("#pjokK4S2").val(respon.pjokK4S2);
      $("#pjokK5S1").val(respon.pjokK5S1);
      $("#pjokK5S2").val(respon.pjokK5S2);
      $("#pjokK6S1").val(respon.pjokK6S1);
      $("#pjokK6S2").val(respon.pjokK6S2);
      // batas Nilai pjok

      // nilai sunda
      $("#sundaK4S1").val(respon.sundaK4S1);
      $("#sundaK4S2").val(respon.sundaK4S2);
      $("#sundaK5S1").val(respon.sundaK5S1);
      $("#sundaK5S2").val(respon.sundaK5S2);
      $("#sundaK6S1").val(respon.sundaK6S1);
      $("#sundaK6S2").val(respon.sundaK6S2);
      // batas Nilai sunda
      $(".tombol-cetak-verifikasi").addClass("d-none");
      $(".modalPendaftar").modal({
        show: true,
        backdrop: false,
      });

      if (respon.id_jalur == 4) {
        // prestasi();
        prestasiOld(respon);
        dataPenyelengara();
      } else if (respon.id_jalur == 2) {
        dataAfirmasiOld(respon);
        // dataAfirmasi();
      } else if (respon.id_jalur == 6) {
        dataNilaiRaport(respon);
      }

      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
  // loading end
});

// batas akhir get data pendaftar
// kumpulan data afirmasi=======================================
function dataAfirmasiOld(respon) {
  $(".konten-syarat").append(
    `
		<div class="row my-3">
			<div class="col my3">
				<label for="namaAfrimasi">Pilih Nama Afirmasi</label>
				<select name="namaAfrimasi" id="namaAfrimasi" class="namaAfrimasi form-control form-control-sm">
				<option value="` +
      respon.id +
      `">` +
      respon.nama_jenis_afirmasi +
      `</option>
				</select>
			</div>
		</div>
		`
  );

  



  
  $(".konten-syarat2").append(
    `
		<div class="row my-3">
			<div class="col-6 col-lg-6">
				<label for="namaPemilik">Nama Sesuai di Kartu ` +
      respon.nama_jenis_afirmasi +
      `</label>
				<input type="text" class="form-control namaPemilik" value="` +
      respon.nama_afirmasi +
      `" name="namaPemilik" id="namaPemilik">
			</div>
			<div class="col-6 col-lg-6">
				<label for="noKartu">No Kartu ` +
      respon.nama_jenis_afirmasi +
      `</label>
				<input type="text" class="form-control noKartu" value="` +
      respon.no_afirmasi +
      `" name="noKartu" id="noKartu">
			</div>
			<div class="col-6 col-lg-6">
				<label for="noKartu">ID DTKS</label>
				<input type="text" class="form-control" value="` +
      respon.dtks +
      `" name="dtks" id="dtks">
			</div>
		</div>
			
		`
  );
}

function clearFormRaport() {
  $('.raport .raport-item1').append(`
  <div class="row my-3">
      <div class="col-4 col-lg-4">
        <label for="totalNilai">Total Rata Rata</label>
        <input type="text" value="" class="totalNilai form-control form-control-sm form-control-custum" readonly name="totalNilai" id="totalNilai"  placeholder="Tempat lahir">
      </div>
    <div class="col-4 col-lg-4">
      <label for="skorRank">Skor Rangking</label>
      <input type="text" value="" class="skorRank form-control form-control-sm form-control-custum" readonly id="skorRank" name="skorRank" placeholder="Rangking">
    </div>
    <div class="col-4 col-lg-4">
      <label for="totalSkor">Total Nilai</label>
      <input type="text" value="" class="totalSkor form-control form-control-sm form-control-custum" readonly id="totalSkor" name="totalSkor" placeholder="Rangking">
    </div>
  </div>

`);
  $('.rangking').append(`
  <option value="0">---Pilih Rangking</option>
`);
$('#paiK4S1').val("")
$('#paiK4S2').val("")
$('#paiK5S1').val("")
$('#paiK5S2').val("")
$('#paiK6S1').val("")

$('#pknK4S1').val("")
$('#pknK4S2').val("")
$('#pknK5S1').val("")
$('#pknK5S2').val("")
$('#pknK6S1').val("")

$('#indoK4S1').val("")
$('#indoK4S2').val("")
$('#indoK5S1').val("")
$('#indoK5S2').val("")
$('#indoK6S1').val("")

$('#mtkK4S1').val("")
$('#mtkK4S2').val("")
$('#mtkK5S1').val("")
$('#mtkK5S2').val("")
$('#mtkK6S1').val("")

$('#ipaK4S1').val("")
$('#ipaK4S2').val("")
$('#ipaK5S1').val("")
$('#ipaK5S2').val("")
$('#ipaK6S1').val("")

$('#ipsK4S1').val("")
$('#ipsK4S2').val("")
$('#ipsK5S1').val("")
$('#ipsK5S2').val("")
$('#ipsK6S1').val("")

$('#sbdpK4S1').val("")
$('#sbdpK4S2').val("")
$('#sbdpK5S1').val("")
$('#sbdpK5S2').val("")
$('#sbdpK6S1').val("")

$('#pjokK4S1').val("")
$('#pjokK4S2').val("")
$('#pjokK5S1').val("")
$('#pjokK5S2').val("")
$('#pjokK6S1').val("")

$('#sundaK4S1').val("")
$('#sundaK4S2').val("")
$('#sundaK5S1').val("")
$('#sundaK5S2').val("")
$('#sundaK6S1').val("")
  
}

// load jenis afirmasi]
function dataAfirmasi() {
  $.ajax({
    url: baseUrl() + "Admin/jenisAfirmasi",
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".konten-syarat .namaAfrimasi").append(
        `<option value="">Nama Afrimasi---</option>`
      );
      $.each(respon, function (i, v) {
        $(".konten-syarat .namaAfrimasi").append(
          `
					<option value="` +
            v.id +
            `">` +
            v.nama_jenis_afirmasi +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}



// memilih jenis Afirmasi
$(".konten-syarat").on("change", ".namaAfrimasi", function () {
  $(".konten-syarat2").html("");
  var id = $(this).val();
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: baseUrl() + "Admin/getAfirmasiById",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      if (respon == null) {
        $(".konten-syarat2").append(`
					<div class="row my-3">
						<div class="col-6 col-lg-6">
							<p class="text-warning">Silahkan pilih jenis afirmasi</p>
						</div>
					</div>
						
					`);
      } else if (respon.id == 5) {
        $(".konten-syarat2").append("");
      } else {
        $(".konten-syarat2").append(
          `
					<div class="row my-3">
						<div class="col-6 col-lg-6">
							<label for="namaPemilik">Nama Sesuai di Kartu ` +
            respon.nama_jenis_afirmasi +
            `</label>
							<input type="text" class="form-control namaPemilik" name="namaPemilik" id="namaPemilik">
						</div>
						<div class="col-6 col-lg-6">
							<label for="noKartu">No Kartu ` +
            respon.nama_jenis_afirmasi +
            `</label>
							<input type="text" class="form-control noKartu" name="noKartu" id="noKartu">
						</div>
					</div>
					<div class="col-6 col-lg-6">
				<label for="noKartu">ID DTKS</label>
				<input type="text" class="form-control"  name="dtks" id="dtks">
				</div>
						
					`
        );
      }

      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
});
// function jalur afirmasi
function afirmasi() {
  dataAfirmasi();
  $(".konten-syarat").append(`
		<div class="row my-3">
			<div class="col my3">
				<label for="namaAfrimasi">Pilih Nama Afirmasi</label>
				<select name="namaAfrimasi" id="namaAfrimasi" class="namaAfrimasi form-control form-control-sm">
				</select>
			</div>
		</div>
		`);
}
// end kumpulan data afirmasi==================================

// function prestasi old
function prestasiKejuaraaUserOld(respon) {
  $(".kejuaraan-main .penyelengara").append(
    `<div class="row my-3">
		<div class="col my3">
			<label for="penyelengara">Pilih Penyelengara</label>
			<select name="penyelengara" id="penyelengara" class="penyelengara form-control form-control-sm">
			<option value="` +
      respon.id_penyelengara +
      `">` +
      respon.peyelengara +
      `</option>
			
			</select>
		</div>
	</div>
`
  );

  $(".konten-syarat2").append(
    `
	<div class="row my-3 .kategori-row">
		<div class="col my3">
			<label for="kategori">Pilih kategori</label>
			<select name="kategori" id="kategori" class="kategori form-control form-control-sm">
				<option value="` +
      respon.id_satuan +
      `">` +
      respon.satuan +
      `</option>
			</select>
		</div>
	</div>
`
  );
  $(".konten-syarat3").append(
    `
<div class="row my-3">
<div class="col my3">
	<label for="tingkatPrestasi">Pilih Tingkat Prestasi</label>
	<select name="tingkatPrestasi" id="tingkatPrestasi" class="tingkatPrestasi form-control form-control-sm">
		<option value="` +
      respon.id_prestasi +
      `">` +
      respon.kejuaraan +
      `</option>
	</select>
</div>
</div>
`
  );

  $(".konten-syarat4").append(
    `
<div class="row my-3">
<div class="col my3">
<label for="Kejuaraan">Nama Kejuaran</label>
<input type="text" value="` +
      respon.namaKejuaraan +
      `" class="form-control form-control-custum" name="namaKejuaraan" id="namaKejuaraan">
</div>
</div>
<div class="row my-3">
	<div class="col my3">
		<label for="skorKejuaraan">Skor Prestasi</label>
		<input type="text" value="` +
      respon.score +
      `" class="form-control form-control-custum skorKejuaraan" name="skorKejuaraan" id="skorKejuaraan" readonly>
	</div>
	<div class="col my3">
		<label for="skorKompetensi">Uji Keterampilan</label>
		<input type="text" value="` +
      respon.skorKompetensi +
      `" class="form-control form-control-custum skorKompetensi" name="skorKompetensi" id="skorKompetensi">
		<smail>Jika Ada koma ganti , dengan . </smail>
	</div>
</div>
`
  );
}


function prestasi() {
  $(".konten-syarat").append(`
			<div class="row my-3">
				<div class="col my3">
					<label for="penyelengara">Pilih Penyelengara</label>
					<select name="penyelengara" id="penyelengara" class="penyelengara form-control form-control-sm">
					
					</select>
				</div>
			</div>
	`);
}

// memilih penyelengara dan menampilkan kategori form kejuaraan
$(".content-syarat-khusus").on("change", ".penyelengara", function () {
  $(".kejuaraan-main #kategori").html('');
  var id = $(this).val();
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: baseUrl() + "Admin/KategoriKejuaraan",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      $(".kejuaraan-main #kategori").append(`<options value="">---Kategori Kejuaraan></option>`)
      $.each(respon, function (i, v) {
        console.info(respon)
        $("#kategori").append(
          `
          <option value="` +
            v.id_satuan +
            `">` +
            v.satuan +
            `</option>
        `
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });




});

  // untuk memilih skor prestasi lewat 
$(".content-syarat-khusus").on("change", ".prestasi", function () {
  $(".content-syarat-khusus .skor").html('');
  $('.skor').val('')
  $('.total_skor_kejuaraan').val('')
  $('.skorKompentensi').val('')
  $('.total_skor_kejuaraan').val('')
  var id = $(this).val();
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: baseUrl() + "Admin/getDataPrestasiById",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      // console.info(respon)
      let skor = $('.skor').val(respon.score)
      $('.total_skor_kejuaraan').val()
      let skorKompentensi = $('.skorKompentensi').val()
      $('.total_skor_kejuaraan').val(skor + skorKompentensi)
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });




});



// batas akhir load kategori kejuaraan

// memilih tingkat prestasi berdasarkan kategori dimenu verifikasi
$(".kejuaraan").on("change", ".kategori", function () {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $(".kejuaraan .prestasi").val('')
  // alert('ok ')
  
  var id = $(this).val();
  $.ajax({
    url: baseUrl() + "Admin/tingkatPrestasi",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      $(".kejuaraan .prestasi").html('');
      $.each(respon, function (i, v) {
        $(".kejuaraan .prestasi").append(
          `
					<option value="` +
            v?.id +
            `">` +
            v?.kejuaraan +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
 
});

$(".konten-syarat3").on("change", ".tingkatPrestasi", function () {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  let id = $(this).val();
  $(".konten-syarat4").html("");
  $(".skorKejuaraan").val("");
  $(".skorPrestasi").val("");

  $.ajax({
    url: baseUrl() + "Admin/getDataPrestasiById",
    method: "post",
    data: {
      id: id,
    },
    dataType: "json",
    success: function (data) {
      $(".konten-syarat4").append(
        `
					<div class="row my-3">
						<div class="col-2 my3">
						<label for="notelepon">Skor</label>
							<input type="text" value="` +
          data.score +
          `" readonly class="form-control form-control-custum" name="skorPrestasi" id="skorPrestasi">
						</div>
						<div class="col my3">
						<label for="notelepon">Nama Kejuaran</label>
							<input type="text" class="form-control form-control-custum namaKejuaraan" name="namaKejuaraan" id="namaKejuaraan">
						</div>
					</div>
					<div class="row my-3">
						<div class="col-2 my3">
						<label for="skorKompetensi">Uji Keterampilan</label>
							<input type="number" class="form-control form-control-custum" name="skorKompetensi" id="skorKompetensi">
							<smail>pengisian nilai 10 - 100</smail>
						</div>
					</div>
				`
      );
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
});

// load data tingkat prestasi
function loadTingkatPrestasi(id) {
  $.ajax({
    url: baseUrl() + "Admin/tingkatPrestasi",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      $(".konten-syarat3 .tingkatPrestasi").append(
        `<option value="">tingkatPrestasi---</option>`
      );
      $.each(respon, function (i, v) {
        $(".konten-syarat3 .tingkatPrestasi").append(
          `
					<option value="` +
            v.id +
            `">` +
            v.kejuaraan +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// ambil data kategori kejuaraan berdasarkan peyelengara
// function loadKategoriKejuaraan(id) {
//   $.ajax({
//     url: baseUrl() + "Admin/KategoriKejuaraan",
//     dataType: "json",
//     method: "post",
//     data: {
//       id: id,
//     },
//     success: function (respon) {
//       $(".content-syarat-khusus .kategori").append(
//         `<option value="">Kategori---</option>`
//       );
//       $.each(respon, function (i, v) {
//         console.info(respon)
//         $(".content-syarat-khusus .kategori_kejuaraan").append(
//           `
// 					<option value="` +
//             v.id_satuan +
//             `">` +
//             v.satuan +
//             `</option>
// 				`
//         );
//       });
//       $(".loading").css("top", "100%");
//       $(".gambar-loading").css("opacity", "0");
//     },
//   });
// }

// ambil data kategori kejuaraan berdasarkan peyelengara
function loadKategoriKejuaraanAll() {
  $.ajax({
    url: baseUrl() + "Admin/KategoriKejuaraanAll",
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".kejuaraan .kategori_kejuaraan").append(
        `<option value="">kategori_kejuaraan---</option>`
      );
      $.each(respon, function (i, v) {
        $(".kejuaraan .kategori_kejuaraan").append(
          `
					<option value="` +
            v.id_satuan +
            `">` +
            v.satuan +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// data
function dataPenyelengara() {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: baseUrl() + "Admin/penyelengara",
    dataType: "json",
    method: "post",
    success: function (respon) {
      console.log(respon);
      $(".kejuaraan-main.penyelengara").append(
        `<option value="">Peyelengara---</option>`
      );
      $.each(respon, function (i, v) {
        $(".kejuaraan-main .penyelengara").append(
          `
				<option value="` +
            v.id_penyelengara +
            `">` +
            v.peyelengara +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// // data
// function dataKategoriKejuaraan() {
//   $(".loading").css("top", "0");
//   $(".gambar-loading").css("opacity", "1");
//   $.ajax({
//     url: baseUrl() + "Admin/KategoriKejuaraan",
//     dataType: "json",
//     method: "post",
//     success: function (respon) {
//       console.log(respon);
//       $(".kejuaraan-main.penyelengara").append(
//         `<option value="">Kategori---</option>`
//       );
//       $.each(respon, function (i, v) {
//         $(".kejuaraan-main .kategori").append(
//           `
// 				<option value="` +
//             v.id_satuan +
//             `">` +
//             v.satuan +
//             `</option>
// 				`
//         );
//       });
//       $(".loading").css("top", "100%");
//       $(".gambar-loading").css("opacity", "0");
//     },
//   });
// }

// ambil data kategori kejuaraan berdasarkan peyelengara
function loadKategoriKejuaraan(id) {
  $.ajax({
    url: baseUrl() + "Admin/KategoriKejuaraan",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      $(".konten-syarat2 .kategori").append(
        `<option value="">Kategori---</option>`
      );
      $.each(respon, function (i, v) {
        $(".konten-syarat2 .kategori").append(
          `
					<option value="` +
            v.id_satuan +
            `">` +
            v.satuan +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// update nilai praktek

$(".tombolMinus").on("click", function () {
  var idEdit = $("#idEdit").val();
  var koregEdit = $("#koregEdit").val();
  var url = $(".url").val();
  var nilai = $(".inputNilaiPraktek").val();
  $.ajax({
    data: {
      id: idEdit,
      koreg: koregEdit,
      nilai: nilai,
    },
    url: url + "Admin/EditMinusNilaiPraktek",
    method: "post",
    dataType: "json",
    success: function (respon) {
      $(".nilaiPrestasiPraktek").val(respon.nilaiPraktekPrestasi);
      $(".nilaiPrestasi").val(respon.nilaiPrestasi);
      $(".inputNilaiPraktek").val(respon.nilaiPraktekPrestasi);
    },
  });
});

$(".tombolPlus").on("click", function () {
  var idEdit = $("#idEdit").val();
  var koregEdit = $("#koregEdit").val();
  var url = $(".url").val();
  var nilai = $(".inputNilaiPraktek").val();
  $.ajax({
    data: {
      id: idEdit,
      koreg: koregEdit,
      nilai: nilai,
    },
    url: url + "Admin/EditMinusNilaiPraktekPlus",
    method: "post",
    dataType: "json",
    success: function (respon) {
      $(".nilaiPrestasiPraktek").val(respon.nilaiPraktekPrestasi);
      $(".nilaiPrestasi").val(respon.nilaiPrestasi);
      $(".inputNilaiPraktek").val(respon.nilaiPraktekPrestasi);
    },
  });
});

// batas akhir update nilai praktek

// ubah score prestasi nonakademik
// $("#prestasi").on("change", function () {
//   var url = $(".url").val();
//   var id = $(this).val();
//   $("#kategori").html("");
//   $.ajax({
//     url: url + "Home/getDataKategoriByidPeyelengara",
//     data: {
//       id: id,
//     },
//     dataType: "json",
//     method: "post",
//     success: function (respon) {
//       $(".kategori").append(
//         `	<option value="">Pilih Kategori Prestasi</option>`
//       );
//       $.each(respon, function (i, v) {
//         $(".kategori").append(
//           `
// 				<option value="` +
//             v.id_satuan +
//             `">` +
//             v.satuan +
//             `</option>
// 				`
//         );
//       });

//       // if (respon == null) {
//       // 	$('#nilaiPrestasi').val('');

//       // } else {
//       // 	$('#nilaiPrestasi').val(respon.score);
//       // }
//     },
//   });
// });
// get data kejuaran with kategory
// $(".kategori").on("change", function () {
//   var url = baseUrl();
//   var id = $(this).val();
//   $("#tingkat").html("");
//   $.ajax({
//     url: url + "Home/getDatatingkatByidKategori",
//     data: {
//       id: id,
//     },
//     dataType: "json",
//     method: "post",
//     success: function (respon) {
//       $(".tingkat").append(`	<option value="">Pilih tingkat Prestasi</option>`);
//       $.each(respon, function (i, v) {
//         $(".tingkat").append(
//           `
// 				<option value="` +
//             v.id +
//             `">` +
//             v.kejuaraan +
//             `</option>
// 				`
//         );
//       });
//     },
//   });
// });
// batas akhir get data kejuaran with kategory
// get nilai prestasi by id tingkat juara
$(".tingkatChange").on("change", function () {
  var url = baseUrl();
  var id = $(this).val();
  $(".nilaiP").html("");
  $.ajax({
    url: url + "Home/getDataNilaiPrestasiByIdTingkat",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
    success: function (respon) {
      $("#nilaiPrestasi").val(respon.score);
      // $('#idPrestasi').val(respon.id
    },
  });
});


// untuk penambahann nilai prestasi non akademil
$('.penyelengaraChange').on('change', function () {
  var url = baseUrl();
  var id = $(this).val();
  $.ajax({
    url: baseUrl() + "Admin/KategoriKejuaraan",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      $(".kategoriChange").html('');
      $(".kategoriChange").append(
        `<option value="">Kategori---</option>`
      );
      $.each(respon, function (i, v) {
      
        $(".kategoriChange").append(
          `
          <option value="` +
            v.id_satuan +
            `">` +
            v.satuan +
            `</option>
        `
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
 
})


$('.kategoriChange').on('change', function () {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
    
  var id = $(this).val();
  $.ajax({
    url: baseUrl() + "Admin/tingkatPrestasi",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      $(".kejuaraan .prestasi").append(
        `<option value="">prestasi---</option>`
      );
      $(".prestasiChange").html('');
      $.each(respon, function (i, v) {
        $(".prestasiChange").append(
          `
            <option value="` +
          v.id +
          `">` +
          v.kejuaraan +
          `</option>
          `
        );
      });
    },
    complete: function () {
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    }
  });
})
   
//     $(".loading").css("top", "100%");
//     $(".gambar-loading").css("opacity", "0");
//   });
// batas akhir get data kejuaran with kategory
// ajax untuk score non akademik
// get data kategori perorangan // groeup dengan id peyelengara
// $(".penyelengara").on("change", function () {
//   $(".kategori").html('');
//   var url = baseUrl();
//   var id = $(this).val();
//   $(".kategori").html("");
//   $.ajax({
//     url: url + "Ppdb/getDataKategoriByIdPeyelengara",
//     data: {
//       id: id,
//     },
//     dataType: "json",
//     method: "post",
//     success: function (respon) {
//       console.log(respon);
//       $(".kategori").append(`	<option value="">Pilih Kategori</option>`);
//       $.each(respon, function (i, v) {
//         $(".kategori").append(
//           `
// 				<option value="` +
//             v.id_satuan +
//             `">` +
//             v.satuan +
//             `</option>
// 				`
//         );
//       });
//     },
//   });
// });
// bats akhir ajax untuk score non akademi
$(document).ready(function () {
  // data tables
  // var url = $(".url").val();
  // var verifikasiTabel = $("#pendaftar").DataTable({
  //   scrollY: "350px",
  //   scrollCollapse: true,
  //   paging: true,
  //   searching: true,
  //   processing: true, //Feature control the processing indicator.
  //   serverSide: true, //Feature control DataTables' server-side processing mode.
  //   bInfo: false,

  //   // Load data for the table's content from an Ajax source
  //   ajax: {
  //     url: url + "Admin/get_ajax",
  //     type: "POST",
  //   },

  //   columnDefs: [
  //     {
  //       targets: [0, 2, 3, -1],
  //       orderable: false,
  //     },
  //   ],
  // });

  // hapus data Skor Rangking
  $(".container-fluid").on("click", ".tombolHapusRangking", function (e) {
    e.preventDefault();
    const hrefHapus = $(this).attr("href");
    Swal.fire({
      title: "Anda Yakin?",
      text: "Ingin Menghapus Data Skor",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Yakin!, Hapus Saja",
    }).then((result) => {
      if (result.value) {
        document.location.href = hrefHapus;
      }
    });
  });

  $("body #formVerifikasi").validate({
    focusInvalid: true,
    rules: rolesFormVerifikasi(),
    messages: messageErrorVerifikasi(),
    submitHandler: function (form) {
      Swal.fire({
        title: "Pesan",
        text: "Verifikasi ?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Ya",
      }).then((result) => {
        if (result.value) {
          saveVerifikasi();
        }
      });
    },
  });

  // akhir validasi form verifikasi
  // funtion roles Verifikasi
  function rolesFormVerifikasi() {
    let roles = {
      noKartu: {
        required: true,
      },
      namaPemilik: {
        required: true,
      },
      penyelengara: {
        required: true,
      },
      namaAfrimasi: {
        required: true,
      },
      kategori: {
        required: true,
      },
      tingkatPrestasi: {
        required: true,
      },
      namaKejuaraan: {
        required: true,
      },

      nama: {
        required: true,
      },
      tempatLahir: {
        required: true,
      },
      tanggalLahir: {
        required: true,
      },
      npsn: {
        required: true,
      },
      longitude: {
        required: true,
      },
      JalurPPDB: {
        required: true,
      },
      namaSekolah: {
        required: true,
      },
    };

    return roles;
  }

  //  function error form Wali
  function messageErrorVerifikasi() {
    let msg = {
      noKartu: {
        required: "Isikan no Kartu",
      },
      namaPemilik: {
        required: "isikan nama pemilik kartu",
      },
      penyelengara: {
        required: "pilih penyelengara",
      },
      namaAfrimasi: {
        required: "pilih jenis afirmasi",
      },
      kategori: {
        required: "pilih kategori",
      },
      tingkatPrestasi: {
        required: "wajib dipilih",
      },
      namaKejuaraan: {
        required: "namaKejuaraan",
      },

      nama: {
        required: "Nama kosong",
      },
      tempatLahir: {
        required: "tempat Lahir Kosong",
      },
      tanggalLahir: {
        required: "tanggal tidak boleh kosong",
      },
      npsn: {
        required: "npsn kosong",
      },
      longitude: {
        required: "longitude kosong",
      },
      JalurPPDB: {
        required: "jalur PPDB kosong",
      },
      namaSekolah: {
        required: "Nama sekolah kosong",
      },
    };
    return msg;
  }

  // verifikasi data dengan ajax
  // $('.tombolsave').on('click', function () {
  function saveVerifikasi() {
    $(".loading").css("top", "0");
    $(".gambar-loading").css("opacity", "1");
    var formV = $(".formVerifikasi").serialize();
    var url = $(".url").val();
    $.ajax({
      url: url + "Admin/verifiksai",
      dataType: "json",
      data: formV,
      method: "post",
      success: function (result) {
        console.log(result);
        if (result.pesan == "error") {
          Swal.fire({
            icon: "danger",
            title: "Data Gagal Tesimpan",
            text: "",
          });
        } else if (result.pesan == false) {
          Swal.fire({
            icon: "success",
            title: "Data Tesimpan",
            text: "",
          });
          $(".jmlPendaftar").html("");
          $(".jmlVerifikasi").html("");
          $(".jmlProses").html("");
          $(".jmlCabut").html("");
          if (result.statusDaftar == 3) {
            $(".tombol-cetak-verifikasi").attr(
              "href",
              url + "admin/cetakBuktiVerifikasi/" + result.koreg
            );
            $(".tombol-cetak-verifikasi").removeClass("d-none");
          } else {
            $(".tombol-cetak-verifikasi").addClass("d-none");
          }
          statistik();
          viewUlangPendaftar(result.koreg, result.id);
          verifikasiTabel.ajax.reload();
          // untuk yang sudah
          tabelVerifikasi.ajax.reload();
          $(".loading").css("top", "100%");
          $(".gambar-loading").css("opacity", "0");
        } else {
          viewUlangPendaftar(result.koreg, result.id);
          Swal.fire({
            icon: "success",
            title: "Perubahan Data Pendaftar",
            text: "Tersimpan !!",
          });
          $(".jmlPendaftar").html("");
          $(".jmlVerifikasi").html("");
          $(".jmlProses").html("");
          $(".belumSubmit").html("");
          $(".jmlCabut").html("");
          if (result.statusDaftar == 3) {
            $(".tombol-cetak-verifikasi").attr(
              "href",
              url + "admin/cetakBuktiVerifikasi/" + result.koreg
            );
            $(".tombol-cetak-verifikasi").removeClass("d-none");
          } else {
            $(".tombol-cetak-verifikasi").addClass("d-none");
          }
          statistik();
          verifikasiTabel.ajax.reload();
          // untuk yang sudah
          tabelVerifikasi.ajax.reload();
          $(".loading").css("top", "100%");
          $(".gambar-loading").css("opacity", "0");
        }
      },
    });
  }
  // })

  // data tables untuk table verifikasi
  // var tabelVerifikasi = $("#tabelVerifikasi").DataTable({
  //   scrollY: "450px",
  //   scrollCollapse: true,
  //   paging: true,
  //   searching: true,
  //   processing: true, //Feature control the processing indicator.
  //   serverSide: true,
  //   bInfo: false,
  //   //Feature control DataTables' server-side processing mode.
  //   // Load data for the table's content from an Ajax source
  //   ajax: {
  //     url: url + "Pendaftar/ambilPendaftar",
  //     type: "POST",
  //   },

  //   columnDefs: [
  //     {
  //       targets: [0, 2, 3, -1],
  //       orderable: false,
  //     },
  //   ],
  // });
  // batas akhir untuk tabel verifikasi\

  // statistik
  function statistik() {
    $(".jmlPendaftar").html("");
    $(".jmlVerifikasi").html("");
    $(".jmlProses").html("");
    $(".jmlCabut").html("");
    $(".belumSubmit").html("");
    var url = $(".url").val();
    $.ajax({
      url: url + "Admin/statistik",
      method: "post",
      dataType: "json",
      success: function (respon) {
        $(".jmlPendaftar").append(respon.daftar);
        $(".jmlVerifikasi").append(respon.verifikasi);
        $(".jmlProses").append(respon.proses);
        $(".jmlCabut").append(respon.mundur);
        $(".belumSubmit").append(respon.belumSubmit);
      },
    });
  }
  // tabel zonasi
  $("#tabelZonasi").DataTable({
    scrollCollapse: true,
    paging: true,
    searching: true,
    columnDefs: [
      {
        targets: [0, 1, 2, 3, 4, 5, 6, -1],
        orderable: false,
      },
    ],
  });

  // tabel zonasi
  $("#tablePrestasi").DataTable();
});

$(".card-body").on("click", ".tombolHapus", function (e) {
  e.preventDefault();
  const hrefHapus = $(this).attr("href");
  Swal.fire({
    title: "Anda Yakin?",
    text: "Ingin Menghapus Data Peserta",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Hapus Saja",
  }).then((result) => {
    if (result.value) {
      document.location.href = hrefHapus;
    }
  });
});

// tombol batalkan data verifikasi
$(".card-body").on("click", ".tombolbatalVerif", function (e) {
  e.preventDefault();
  const hrefnya = $(this).attr("href");
  let koreg=$(this).data('koreg');
  let id = $(this).data('id');
  let nama = $(this).data('nama');
  Swal.fire({
    title: "Anda Yakin?",
    text: `Ingin Mebatalkan Verifikasi Data Peserta ${nama} dengan Kode: ${koreg}`,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Reset ke Verifikasi",
  }).then((result) => {
    if (result.value) {
      document.location.href = hrefnya;
    }
  });

})

// tombol batalkan data verifikasi
$(".card-body").on("click", ".tombolCabutBerkas", function (e) {
  e.preventDefault();
  const hrefnya = $(this).attr("href");
  let koreg=$(this).data('koreg');
  let nama = $(this).data('nama');
  Swal.fire({
    title: "Anda Yakin?",
    text: `Ingin Mengeluarkan Peserta  ${nama} dengan Kode: ${koreg} Dari Seleksi System PPDB`,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6", 
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Reset ke Verifikasi",
  }).then((result) => {
    if (result.value) {
      document.location.href = hrefnya;
    }
  });

})

// tabel kelulusan
$("#tabelLulus").DataTable({
  scrollCollapse: true,
  paging: true,
  searching: true,
});
// tabel kelulusan
$("#tabelBelumSubmit").DataTable({
  scrollCollapse: true,
  paging: true,
  searching: true,
});
// table persyaratan
$(".tablePeryaratan").DataTable({
  scrollCollapse: true,
  paging: true,
  searching: true,
});
// tobol resset
$(".tombol-reset").on("click", function (e) {
  e.preventDefault();
  let hrefNya = $(this).attr("href");
  Swal.fire({
    title: "Anda Yakin?",
    text: "Ingin Mereset Data Status menjadi  Verifikasi",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Reset Saja",
  }).then((result) => {
    if (result.value) {
      document.location.href = hrefNya;
    }
  });
});

// tobol kosongkan
$(".tombol-kosongkan").on("click", function (e) {
  e.preventDefault();
  let hrefNya = $(this).attr("href");
  Swal.fire({
    title: "Anda Yakin?",
    text: "Ingin Mengosongkan Database kami sarankan untuk meng backup dulu database ",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Kosongkan Saja Saja",
  }).then((result) => {
    if (result.value) {
      document.location.href = hrefNya;
    }
  });
});

// tombol-generatet
$(".tombol-generatet").on("click", function (e) {
  e.preventDefault();
  let hrefNya = $(this).attr("href");
  Swal.fire({
    title: "Anda Yakin?",
    text: "Ingin Mengenerate Data ini, kami sarankan cek kembali dan tutup form pendaftaran sebelum generate data",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yakin!, Generate Saja",
  }).then((result) => {
    if (result.value) {
      document.location.href = hrefNya;
    }
  });
});

// view ulang data pendaftar setelah edit dengan ajx
function viewUlangPendaftar(koreg, id) {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: baseUrl() + "Admin/getDataPendaftarById",
    method: "POST",
    data: {
      id: id,
      koreg: koreg,
    },
    dataType: "json",
    success: function (respon) {
      if (respon.statusDaftar == 2) {
        $("#ver1").attr("checked", "checked");
        $(".tombol-cetak-verifikasi").addClass("d-none");
      } else if (respon.statusDaftar == 3) {
        $("#ver2").attr("checked", "checked");
        $(".tombol-cetak-verifikasi").removeClass("d-none");
      } else {
        $("#ver3").attr("checked", "checked");
        $(".tombol-cetak-verifikasi").addClass("d-none");
      }
      // form value
      $("#koreg").val(respon.koreg);
      $("#nama").val(respon.nama);
      $("#nisn").val(respon.nisnPendaftar);
      $("#namaSekolah").val(respon.sekolahAsal);
      $("#npsn").val(respon.npsn);
      $("#JalurPPDB").val(respon.id_jalur);
      $("#nilaiJarak").val(respon.jarak);
      $("#totalNilai").val(respon.total);
      // $('#longitude').val(respon.longitude)
      $("#idDaftar").val(respon.id_pendaftar);
      $("#koregSen").val(respon.koreg);
      $("#tempatLahir").val(respon.tempatLahir);
      $("#tanggalLahir").val(respon.tglLahir);
      $("#usiaSiswa").val(respon.usia + " Tahun");

      // buat apdate nilai prkatek
      $("#idEdit").val(respon.id);
      $("#koregEdit").val(respon.koreg);
      // nilai pai
      $("#paiK4S1").val(respon.paiK4S1);
      $("#paiK4S2").val(respon.paiK4S2);
      $("#paiK5S1").val(respon.paiK5S1);
      $("#paiK5S2").val(respon.paiK5S2);
      $("#paiK6S1").val(respon.paiK6S1);

      // batas Nilai pai

      // nilai pkn
      $("#pknK4S1").val(respon.pknK4S1);
      $("#pknK4S2").val(respon.pknK4S2);
      $("#pknK5S1").val(respon.pknK5S1);
      $("#pknK5S2").val(respon.pknK5S2);
      $("#pknK6S1").val(respon.pknK6S1);

      // batas Nilai pkn

      // nilai indo
      $("#indoK4S1").val(respon.indoK4S1);
      $("#indoK4S2").val(respon.indoK4S2);
      $("#indoK5S1").val(respon.indoK5S1);
      $("#indoK5S2").val(respon.indoK5S2);
      $("#indoK6S1").val(respon.indoK6S1);

      // batas Nilai indo

      // nilai mtk
      $("#mtkK4S1").val(respon.mtkK4S1);
      $("#mtkK4S2").val(respon.mtkK4S2);
      $("#mtkK5S1").val(respon.mtkK5S1);
      $("#mtkK5S2").val(respon.mtkK5S2);
      $("#mtkK6S1").val(respon.mtkK6S1);

      // batas Nilai mtk

      // nilai ipa
      $("#ipaK4S1").val(respon.ipaK4S1);
      $("#ipaK4S2").val(respon.ipaK4S2);
      $("#ipaK5S1").val(respon.ipaK5S1);
      $("#ipaK5S2").val(respon.ipaK5S2);
      $("#ipaK6S1").val(respon.ipaK6S1);

      // batas Nilai ipa

      // nilai ips
      $("#ipsK4S1").val(respon.ipsK4S1);
      $("#ipsK4S2").val(respon.ipsK4S2);
      $("#ipsK5S1").val(respon.ipsK5S1);
      $("#ipsK5S2").val(respon.ipsK5S2);
      $("#ipsK6S1").val(respon.ipsK6S1);

      // batas Nilai ips

      // nilai sbdp
      $("#sbdpK4S1").val(respon.sbdpK4S1);
      $("#sbdpK4S2").val(respon.sbdpK4S2);
      $("#sbdpK5S1").val(respon.sbdpK5S1);
      $("#sbdpK5S2").val(respon.sbdpK5S2);
      $("#sbdpK6S1").val(respon.sbdpK6S1);

      // batas Nilai sbdp

      // nilai pjok
      $("#pjokK4S1").val(respon.pjokK4S1);
      $("#pjokK4S2").val(respon.pjokK4S2);
      $("#pjokK5S1").val(respon.pjokK5S1);
      $("#pjokK5S2").val(respon.pjokK5S2);
      $("#pjokK6S1").val(respon.pjokK6S1);

      // batas Nilai pjok

      // nilai sunda
      $("#sundaK4S1").val(respon.sundaK4S1);
      $("#sundaK4S2").val(respon.sundaK4S2);
      $("#sundaK5S1").val(respon.sundaK5S1);
      $("#sundaK5S2").val(respon.sundaK5S2);
      $("#sundaK6S1").val(respon.sundaK6S1);
      // batas Nilai sunda
      // $('.tombol-cetak-verifikasi').addClass('d-none');
      $(".modalPendaftar").modal({
        show: true,
        backdrop: false,
      });

      // if (respon.id_jalur == 4) {
      // 		// prestasi();
      // 		prestasiOld(respon);
      // 		dataPenyelengara();

      // }
      // else if (respon.id_jalur == 2) {
      // 	dataAfirmasiOld(respon);
      // 	// dataAfirmasi();
      // }

      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
  // loading end
}

// ================================pilih data provinsi untuk form alamat verifikasi
$('.formAlamat .changeProvinsi').on('change', function () {
  var id = $(this).val();
  $(".formAlamat .changeKota").html("")
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: baseUrl() + "Home/dataKota",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
   
    success: function (respon) {
      $(".formAlamat .changeKota").append(`	<option value="">Pilih Kota / Kabupaten</option>`);
      $.each(respon, function (i, v) {
        $(".formAlamat .changeKota").append(
          `
                    <option value="` +
            v.id +
            `">` +
            v.name +
            `</option>
                    `
        );
      });
     
    },
    complete: function () {
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    }
  });
  
  
})


// change kota
$(".formAlamat .changeKota").on("change", function () {
  $(".formAlamat .changeKecamatan").html("");
  var id = $(this).val();
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: baseUrl() + "Home/dataKecamatan",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".formAlamat .changeKecamatan").append(`<option value="">Pilih Kecamatan</option>`);
      $.each(respon, function (i, v) {
        $(".changeKecamatan").append(
          `
                    <option value="` +
            v.id +
            `">` +
            v.name +
            `</option>
                    `
        );
        $(".loading").css("top", "100%");
        $(".gambar-loading").css("opacity", "0");
      });
    },
  });
});


// change kecamtan
$(".formAlamat .changeKecamatan").on("change", function () {
  $(".formAlamat .changeDesa").html("");
  var id = $(this).val();
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: baseUrl() + "Home/dataDesa",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".formAlamat .changeDesa").append(`<option value="">Pilih Desa</option>`);
      $.each(respon, function (i, v) {
        $(".changeDesa").append(
          `
                    <option value="` +
            v.id +
            `">` +
            v.name +
            `</option>
                    `
        );
        $(".loading").css("top", "100%");
        $(".gambar-loading").css("opacity", "0");
      });
    },
  });
});
// ================================Pilih alamat provinsi kota, kecamatan dan desa

$(".provinsi").on("change", function () {
  var url = $(".url").data("url");
  var id = $(this).val();
  $('.modal-body .selectKota').val('')
  $('.modal-body .selectKecamatan').val('')
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  // $("#kota").val("");
  $.ajax({
    url: url + "Home/dataKota",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".modal-body .selectKota").append(`	<option value="">Pilih Kota / Kabupaten</option>`);
      $.each(respon, function (i, v) {
        $(".selectKota").append(
          `
                    <option value="` +
            v.id +
            `">` +
            v.name +
            `</option>
                    `
        );
      });
     
    },
    complete: function () {
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    }
  });
});

// memilih data kota dan mengambila data kecamatan
$(".selectKota").on("change", function () {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  var url = $(".url").data("url");
  var id = $(this).val();
  $(".selectKecamatan").html("");
  $.ajax({
    url: url + "Home/dataKecamatan",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".selecKecamatan").append(`<option value="">Pilih Kecamatan</option>`);

      $.each(respon, function (i, v) {
        $(".selectKecamatan").append(
          `
                    <option value="` +
            v.id +
            `">` +
            v.name +
            `</option>
                    `
        );
        $(".loading").css("top", "100%");
        $(".gambar-loading").css("opacity", "0");
      });
    },
  });
});

// memilih data kecamatan untuk mengambil data desa
$(".selectKecamatan").on("change", function () {
  var url = $(".url").data("url");
  var id = $(this).val();
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $(".selectDesa").html("");
  $.ajax({
    url: url + "Home/dataDesa",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".desa").append(`	<option value="">Pilih Desa</option>`);
      $.each(respon, function (i, v) {
        $(".selectDesa").append(
          `
                    <option value="` +
            v.id +
            `">` +
            v.name +
            `</option>
                    `
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
});

// riset pin peseta make nisn
$(".tombol-riset-pin").on("click", function () {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  let nisn = $(".risetPIN").val();
  var url = $(".url").data("url");
  $.ajax({
    url: url + "Setting/resetPIN",
    method: "post",
    dataType: "json",
    data: {
      nisn: nisn,
    },
    success: function (respon) {
      // console.log(respon.pesan)
      if (respon.pesan == "noUser") {
        Swal.fire({
          icon: "warning",
          title: "Error",
          text: "NISN User dengan no " + nisn + " tidak ditemukan",
        });
        $(".risetPIN").val("");
      } else if (respon.pesan == "ada") {
        Swal.fire({
          icon: "success",
          title: "Berhasil !",
          text:
            "NISN  dengan no " +
            nisn +
            " atas nama : " +
            respon.user +
            " pin berhasil diset ulang dengan = " +
            respon.newPIN +
            "",
        });
        $(".risetPIN").val("");
      }
    },
  });

  // jalankan ajax

  $(".loading").css("top", "100%");
  $(".gambar-loading").css("opacity", "0");
});

// table operator
$("#table-operator").DataTable({
  scrollCollapse: true,
  paging: true,
  searching: true,
  bInfo: false,
});

// validasi form operator
$("body #formOperator").validate({
  focusInvalid: true,
  rules: {
    password: {
      required: true,
      minlength: 5,
    },
    password_repeat: {
      required: true,
      minlength: 5,
      equalTo: "#passwordOperator",
    },
    nama: {
      required: true,
    },
    email: {
      required: true,
      email: true,
      // remote: {
      //   url: baseUrl() + "Admin/cekEmaiOperator",
      //   type: "post",
      //   dataType: "json",
      //   data: {
      //     email: function () {
      //       return $("#emailOperator").val();
      //     },
      //   },
      //   success: function (respon) {
      //     if (respon == true || respon == "1") {
      //       return "false";
      //     } else {
      //       return "true";
      //     }
      //   },
      // },
    },
    namaSekolahOps: {
      required: true,
    },
    npsnOps: {
      required: true,
      number: true,
    },
  },
  messages: {
    password: {
      required: "password di isi",
      minlength: "minimal 5 karakter",
    },
    password_repeat: {
      required: "password harus di isi",
      minlength: "minimal 5 karakter",
      equalTo: "password tidak sama",
    },
    nama: {
      required: "nama harus di isi",
    },
    email: {
      required: "email tidak boleh kosong",
      email: "format email tidak valid",
      remote: "email telah digunakann",
    },
    namaSekolahOps: {
      required: "nama sekolah harus di isi !",
    },
    npsnOps: {
      required: "npsn tidak boleh kosong",
      number: "hanya boleh angka !!",
    },
  },
});


// loading end
$(".loading").css("top", "100%");
$(".gambar-loading").css("opacity", "0");
